"""
Read Block Model File
=====================

This example shows how to read a block model file.
"""
from geoassistant import BlockModel

bmodel_path = "../resources/bmodel_01.csv"

# %%
# GeoAssistant `BlockModel.load` detects the file extension, read the file and returns a BlockModel instance:
bm = BlockModel.load(filepath=bmodel_path)

# %%
# At this point, the model is read and loaded using *pyarrow* under the hood.
# However, GeoAssistant does not yet know what the model is actually representing. **You** need to explicitly specify this.
#
# First, let’s define the coordinate keys:
bm.setPositionKeys(xkey="centroid_x", ykey="centroid_y", zkey="centroid_z")

