"""
Read PLT Tests
==============

This example shows how to read a PLT diametral tests from drill holes.
"""
import os

import geoassistant


# Path to example data
test_resources_dir = os.path.join("../resources/read_plt/")
filepath = os.path.join(test_resources_dir, 'COLLAR_PLT.xlsx')

# %%
# See also: :ref:`plt-common_data`

dhs = geoassistant.readDrillholesExcelSheet(filepath=filepath, sheetname="COLLAR",
                                            hole_id_col="B",
                                            collar_x_col="C", collar_y_col="D", collar_z_col="E",
                                            survey_azimuth_col="G", survey_dip_col="H",
                                            length_col="F")

plt_collection = geoassistant.readPLTExcelSheet(filepath=filepath, sheetname="PLT",
                                                depth_col="C",
                                                load_col="E",
                                                load_units="KN", sample_type="diametral",
                                                id_col="B", drillholes=dhs)

print(len(plt_collection))
